TITLE 							                { exa032a.pde }
   'Non-Constant Omega'
SELECT
   spectral_colors
DEFINITIONS                                     			{ SI units }
   r1=1.0
   rad=sqrt( x^2+y^2)     omega=sin( rad)
   vx=-omega*y     vy=omega*x      				{ Velocity }
   v=vector( vx, vy)     vm=sqrt( vx^2+vy^2) 		{ Magnitude }
   div_v=dx(vx)+ dy(vy)     curl_z=dx(vy)- dy(vx)
BOUNDARIES
region 'domain'
   start(r1,0) arc to (0,r1) to (-r1,0) to (0,-r1) close  	
PLOTS
   contour(vx)     contour(vy)
   contour( abs(vx)) log   				{ Log10 of absolute value }
   contour( abs(vy)) log	
   contour( div_v)     contour( curl_z)
   contour( vm) log     vector( v/vm)				{ Unit magnitude }
END

